% Beamforming plot v0.2

%% Add directories containing support functions.
addpath('functions')

%% Inputs
d = 11.43e-3;       % Distance between microphones.
N = 24;             % Number of microphones.
f = 25e3;           % Frequency of source.
phi = d2r(90);      % Look-direction of beam.
psi = linspace(0, pi, 1000);    % Arc/cone of interest
c = 343;          % Velocity of sound (in air).

cutoff = -50;

%% Array Pattern
for freq = [ 20e3 25e3 30e3 35e3]
    
    i1 = cos(psi)-cos(phi);
    i2 = (pi*freq*d.*i1)./c;
    W = 20*log10(abs( sin(N.*i2)./(N*sin(i2))));
    W(W < cutoff) = cutoff;
  
    % Polar plots
    figure
    pa = polaraxes;
    polarplot(pa, psi, W);
    pa.ThetaLim = [0 180]
    rlim([cutoff 0])
    hold on
    polarplot([phi phi], [0 cutoff], '--')
    hold off
    %haxes = get(h,'Parent');
    %haxes.RTickLabel = {'-50','-40','-30','-20','-10','0'};
end

% Cartesian plots
figure
ca = axes;
plot(ca, psi, W)
grid on
title('Cartesian')
xlabel('Arrival Angle (deg)')
ylabel('Gain (dB)')





